implementation module test_graph_copy

import StdEnv,StdStrictLists

import windows
import copy_graph

//N_THREADS:==1
N_THREADS:==4

foreign export threadFunc

threadFunc_address :: Int;
threadFunc_address = code {
|	pushLc threadFunc
	pushL threadFunc
}

threadFunc :: !LPVOID -> DWORD
threadFunc n
	= maxList [copy_list_to_string_and_to_list_again i\\i<-[1..10000]];

copy_list_to_string_and_to_list_again i
	#! v=[!1..i!];
//	#! v=[#1..i!];

	# s = copy_to_string v;
	# (a,_) = copy_from_string s;
	= test_and_length 1 a;

test_and_length :: Int [!Int!] -> Int
//test_and_length :: Int [#Int!] -> Int
test_and_length n [|]
	= n-1
test_and_length n [|e:l]
	| e==n
		= test_and_length (n+1) l;

load_int :: !Int !Int -> (!Int,!Int);
load_int o p = code {
	push_b 1
	push_b 1
	addI
	load_i 0
	updatepop_b 0 1
}

store_int v o p :== IF_INT_64_OR_32 (store_int_64 v o p) (store_int_32 v o p);

store_int_64 :: !Int !Int !Int -> Int;
store_int_64 v o p = code {
	push_b 1
	pushI -8
	addI
	update_b 0 2
	pop_b 1

	push_b 2
	push_b 2
	addI
	push_b_a 0
	pop_b 1
	fill1_r _ 0 1 0 01
	push_a_b 0
	pop_a 1

	push_b 1
	push_b 1
	subI
	updatepop_b 0 3
}

store_int_32 :: !Int !Int !Int -> Int;
store_int_32 v o p = code {
	push_b 1
	pushI -4
	addI
	update_b 0 2
	pop_b 1

	push_b 2
	push_b 2
	addI
	push_b_a 0
	pop_b 1
	fill1_r _ 0 1 0 01
	push_a_b 0
	pop_a 1

	push_b 1
	push_b 1
	subI
	updatepop_b 0 3
}

clean_new_thread_address :: Int
clean_new_thread_address = code {
|	pushLc clean_new_thread
	pushL clean_new_thread
}

alloc threadFunc_address ph ws
  #	(p1,ws) = HeapAlloc ph 0 (3<<(IF_INT_64_OR_32 3 2)) ws;
  | p1==NULL
  	= abort "HeapAlloc failed";
  # p1 = store_int threadFunc_address 0 p1;
    p1 = store_int 0 (IF_INT_64_OR_32 8 4) p1;
    p1 = store_int 0 (IF_INT_64_OR_32 16 8) p1;
  = (p1,ws);

create_threads thread_n n_threads ph threadFunc_address ws
	| thread_n<n_threads
 		# (p,ws) = alloc threadFunc_address ph ws
   		  (thread_handle,thread_id1,ws) = CreateThread 0 0 clean_new_thread_address p 0 ws
		#! (threads_pointers,ws) = create_threads (thread_n+1) n_threads ph threadFunc_address ws
		= ([(thread_handle,p):threads_pointers],ws)
		= ([],ws);

wait_thread thread_handle p ph ws
  #	(r,ws) = WaitForSingleObject thread_handle INFINITE ws;
	ws = CloseHandle thread_handle ws;
	(b,ws) = HeapFree ph 0 p ws;
  |	b==0
  	= abort "HeapFree failed";
  	= ws;

wait_threads [(thread_handle,p):thread_handles] ph ws
	# ws = wait_thread thread_handle p ph ws
	= wait_threads thread_handles ph ws
wait_threads [] ph ws
	= ws

Start
	# ws = 123456789;
	  (ph,ws) = GetProcessHeap ws;
	  (thread_handles_and_pointers,ws) = create_threads 0 N_THREADS ph threadFunc_address ws
	= wait_threads thread_handles_and_pointers ph ws
